

package _Text_Book;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 *
 * @author John Rayworth
 * International School of Prague
 * jrayworth@isp.cz
 */


public class _5_TheWhileLoop {
    
    
    //This may be a good place to start a "Rosetta Stone"
    //exercise, like The Oregon Trail.
    
    
    

    //The While Loop loops through lines of code an indefinite number of times.
    //The number of times it repeats depends on a boolean variable that can evaluate
    //                                            to either true or false.
    
    public static void main(String[] args) throws IOException {
        
        //whileLoopParts();
        appropriateWhileLoop();
        //aCompoundConditionLoop();
        
        //the_Dont_Worry_About_The_Code_Just_Have_Fun_Part();

    }
    
    
    
    
    
  
    
    
    
    
    
    
    
    
    
    
    
    public static void whileLoopParts(){
        /*
        * 
        * There are several ways to accomplish "iteration", or looping, or repeating
        * with code.
        * The best one to start with is the while loop.
        *
        * It continues to repeat a block of code as long as a certain condition is true.
        * But within the loop, there is a line which works a "Loop Control Variable" toward
        * some sort of bound, which, when reached, will make the condition for continuing
        * the loop to be false, thus ending the loop.
        * 
        */

                                                                                                               line();
        int i = 0; // Part 1: Initialization of a "Loop Control Variable"
        while(i < 10){ // Part 2: A condition upon which the loop continues
            System.out.println("While loop i: " + i);
            i++; // Part 3: The Loop Control Variable is worked toward a bound
                 // so that eventually the condition above will be false and the loop ended.
        }

    }
    
    // So in the example above, the loop will continue as long as the variable
    // i is less than 10.
    
    // In this example, the loop will always execute exactly 10 times. Note that 
    // you actually shouldl use a "for loop" (see next section) when there are an exact
    // number of times you wish to repeat something. 
    
    
    
    
    
    
    
    
    
    
    
  
    
    
    
    
    
    
    public static void appropriateWhileLoop(){
        
        /*
        * 
        * Normally, though, a while is used when there's a situation when a loop will repeat
        * while some variable condition is true or not true.
        * 
        * Here is a cool example.
        */
        
        
        double startTime = System.currentTimeMillis();//The current time in milliseconds
        
        //int counter = 0;
        while(System.currentTimeMillis() < startTime + 5000){//So this should loop for 5 seconds.   
            System.out.println("HelloWorld ");// + System.currentTimeMillis());
            //System.out.println(counter); //To show how it's usually a different number of loops.
            //counter++;
        }
        
 
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
  
    
    
    
    
    public static void aCompoundConditionLoop() throws IOException{
        
        
       /*
        * 
        * Sometimes there can be more than one condition which controls a while loop continuing.
        * 
        * If it's one thing and another which have to be true or false, we use && for AND.
        * And if it's one or the other which have to be true or false, we use || for OR.
        * 
        * 
        * If one of the conditions needs to evaluate to false to continue, we use ! for NOT.
        * 
        */
        
        
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        boolean wantToContinue = true;
        boolean stillTheLesson = true;
        while(wantToContinue && stillTheLesson){
            System.out.println("Let's keep going!!!!!");
            System.out.println("");
            System.out.println("Do you want to continue? true/false");
            wantToContinue = Boolean.parseBoolean(br.readLine());
            System.out.println("Is it still the lesson? true/false");
            stillTheLesson = Boolean.parseBoolean(br.readLine());
            
        }
        System.out.println("Either you don't want to continue, or the lesson is over.");
        
        
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public static void line(){
        System.out.println("________________________");
        System.out.println("");
    }
    
}
